--[[
HMB -- Hatty's Mark Bar v 1.3
Written by Hatty
]]

DEFAULT_CHAT_FRAME:AddMessage('Hatty\'s Mark Bar v1.3 загружен')

hmb = {} -- HMB frames and functions
hmb_settings = { -- default settings, gets saved
    locked = 0,  -- not locked by default
    enabled = 1,   -- shown by default
    scale = 1    -- scale at which everything is drawn
} 

SlashCmdList['HMB'] = function(msg, editbox) -- anon function, im lazy. sue me
    local cmd, arg = msg:match('^(%S+)%s*(.*)$')
    if cmd == 'toggle' then
        hmb:toggle()
    elseif cmd == 'scale' then
        local s = tonumber(arg)
        if s == nil or s < 0.1 or s > 2.0 then
            DEFAULT_CHAT_FRAME:AddMessage('Ошибка HMB: значение масштаба, должено быть между 0.1 и 2.0')            
        else
            hmb_settings['scale'] = s
            hmb['markbar']:SetScale(s)
        end
    elseif cmd == 'enable' then
        if hmb_settings['enabled'] == 1 then
            hmb_settings['enabled'] = 0
        else
            hmb_settings['enabled'] = 1
        end
        hmb:showhide()
    else
        DEFAULT_CHAT_FRAME:AddMessage('HMB - Hatty\'s mark bar v1.3')
        DEFAULT_CHAT_FRAME:AddMessage('/hmb toggle      Переключение HMB')
        DEFAULT_CHAT_FRAME:AddMessage('/hmb scale n     Масштаб HMB. Вместо n, значение (значение между 0.1-2.0)')
        DEFAULT_CHAT_FRAME:AddMessage('/hmb enable      Включает HMB если выключен')
    end
end
SLASH_HMB1 = '/hmb'


-- HMB Marking bar
hmb['markbar'] = CreateFrame('frame', 'hmb_bar', UIParent)

hmb['markbar']:SetBackdrop({ -- give it a background and a border
        bgFile = 'Interface\\DialogFrame\\UI-DialogBox-Background',
        edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border',
        tile = true,
        insets = {left = 6, right = 6, top = 6, bottom = 6}})
hmb['markbar']:SetHeight(68);
hmb['markbar']:SetWidth(500);
hmb['markbar']:SetClampedToScreen(true) -- can't move off screen
hmb['markbar']:SetPoint('CENTER')
hmb['markbar']:SetMovable(true)
hmb['markbar']:EnableMouse(true)
hmb['markbar']:SetScript('OnEvent', function() hmb:onevent(frame, event) end)
hmb['markbar']:SetScript('OnMouseDown', function() if hmb_settings['locked'] == 0 then hmb['markbar']:StartMoving() end end)
hmb['markbar']:SetScript('OnMouseUp', function() hmb['markbar']:StopMovingOrSizing() end)
hmb['markbar']:SetScript('OnDragStop', function() hmb['markbar']:StopMovingOrSizing() end)
hmb['markbar']:RegisterEvent('PARTY_MEMBERS_CHANGED')
hmb['markbar']:RegisterEvent('PARTY_LEADER_CHANED')
hmb['markbar']:RegisterEvent('VARIABLES_LOADED')

hmb['markbar']:Hide() -- Hide by default, will be shown on variable load if needed to

-- Buttons
hmb['buttons'] = {
    {tooltip='Звезда',         frame=CreateFrame('button', 'hmb_btn_star',       hmb['markbar'], 'ActionButtonTemplate')},
    {tooltip='Круг',       frame=CreateFrame('button', 'hmb_btn_circle',     hmb['markbar'], 'ActionButtonTemplate')},
    {tooltip='Ромб',      frame=CreateFrame('button', 'hmb_btn_diamond',    hmb['markbar'], 'ActionButtonTemplate')},
    {tooltip='Треугольник',     frame=CreateFrame('button', 'hmb_btn_triangle',   hmb['markbar'], 'ActionButtonTemplate')},
    {tooltip='Луна',         frame=CreateFrame('button', 'hmb_btn_moon',       hmb['markbar'], 'ActionButtonTemplate')},
    {tooltip='Квадрат',       frame=CreateFrame('button', 'hmb_btn_square',     hmb['markbar'], 'ActionButtonTemplate')},
    {tooltip='Крест',        frame=CreateFrame('button', 'hmb_btn_cross',      hmb['markbar'], 'ActionButtonTemplate')},
    {tooltip='Череп',        frame=CreateFrame('button', 'hmb_btn_skull',      hmb['markbar'], 'ActionButtonTemplate')},
    {tooltip='Проверка готовности',  frame=CreateFrame('button', 'hmb_btn_ready',      hmb['markbar'], 'ActionButtonTemplate')},
    {tooltip='Блокировать/Разблокировать',  frame=CreateFrame('button', 'hmb_btn_lockunlock', hmb['markbar'], 'ActionButtonTemplate')}
}


hmb['buttons'][1]['frame']:SetPoint('TOPLEFT', hmb['markbar'], 16, -16)
for i = 1, 10  do
    if i > 1 then
        hmb['buttons'][i]['frame']:SetPoint('TOPLEFT', hmb['buttons'][i - 1]['frame'], 'TOPRIGHT', 12, 0)
    end
    --hmb['buttons'][i]['frame']:SetScale(0.5)
    hmb['buttons'][i]['frame']:SetScript("OnEnter", function() hmb:tooltip(i) end) -- Anonymous function for tooltip
    hmb['buttons'][i]['frame']:SetScript("OnLeave", function() GameTooltip:Hide() end) -- Anonymous function for hiding tooltip

    -- Set textures on onclick handlers
    hmb['buttons'][i]['frame']:SetNormalTexture('Interface\\Buttons\\UI-Quickslot2')
    local icon = getglobal(hmb['buttons'][i]['frame']:GetName() .. 'Icon') 
    if i < 9 then
        hmb['buttons'][i]['frame']:SetScript("OnClick", function() hmb:mark(i) end) -- Anonymous function to mark with id
        icon:SetTexture('Interface\\TargetingFrame\\UI-RaidTargetingIcon_' .. i)
    elseif i == 9 then
        hmb['buttons'][i]['frame']:SetScript("OnClick", function() DoReadyCheck() end)
        icon:SetTexture('Interface\\RAIDFRAME\\ReadyCheck-Ready')
    elseif i == 10 then
        hmb['buttons'][i]['frame']:SetScript("OnClick", function() hmb:lockunlock() end)
        icon:SetTexture('Interface\\GLUES\\CharacterSelect\\Glues-Addon-Icons')
        icon:SetTexCoord(0, .25, 0, 1)
    end
end

function hmb:toggle()
    if (hmb['markbar']:IsVisible()) then
        hmb['markbar']:Hide()
    else
        hmb['markbar']:Show()
    end
end

function hmb:lockunlock()
    local icon = getglobal('hmb_btn_lockunlockIcon')
    if (hmb_settings['locked'] == 1) then
        hmb_settings['locked'] = 0
        icon:SetTexCoord(0, 0.25, 0, 1)
    else 
        hmb_settings['locked'] = 1
        icon:SetTexCoord(0.25, 0.50, 0, 1)
    end
end

function hmb:tooltip(id)
    GameTooltip:SetOwner(hmb['buttons'][id]['frame'], 'ANCHOR_BOTTOMLEFT')
    GameTooltip:SetText(hmb['buttons'][id]['tooltip'])
end

function hmb:showhide()
    if GetNumRaidMembers() > 0 and (IsRaidLeader() or IsRaidOfficer()) and hmb_settings['enabled'] == 1 then
        hmb['markbar']:Show()
    elseif GetNumPartyMembers() > 0 and IsPartyLeader() and hmb_settings['enabled'] == 1 then
        hmb['markbar']:Show()
    else
        hmb['markbar']:Hide()
    end
end

function hmb:onevent()
    if event == 'VARIABLES_LOADED' then
        hmb['markbar']:SetScale(hmb_settings['scale'])
        hmb:showhide()
        if hmb_settings['locked'] == 1 then
            local icon = getglobal('hmb_btn_lockunlockIcon')
            icon:SetTexCoord(0.25, 0.50, 0, 1)
        end
    elseif event == "PARTY_MEMBERS_CHANGED" or event == "PARTY_LEADER_CHANGED" then
        hmb:showhide() 
    end
end

function hmb:mark(id)
    if (UnitExists("target")) then
        SetRaidTargetIcon("target", id)
    end
end
