-- FuBar_HBskinFu: Simple skin changer FuBar plugin for HealBot.
-- Copyright (C) 2009  jicao - Chojnowski Benjamin (Visit http://muse-gaming.org for contact)
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

--
-- Special thanks to Fubar_HealbotFU !

--
-- Initialising
HBskinFu = AceLibrary("AceAddon-2.0"):new("AceDB-2.0", "AceConsole-2.0", "AceEvent-2.0", "FuBarPlugin-2.0");

local tablet = AceLibrary("Tablet-2.0");
local dewdrop = AceLibrary("Dewdrop-2.0");

--
-- FuBar Options
HBskinFu.title = "Fubar - HBskinFu";
HBskinFu.defaultPosition = "LEFT";
HBskinFu.hasIcon = true;
HBskinFu.cannotDetachTooltip = false;
HBskinFu.tooltipType = "Tablet-2.0";

HBskinFu:RegisterDB("HBskinFuDB");
HBskinFu:RegisterDefaults("profile", {});

--
-- HBskinFu menu
function HBskinFu:OnMenuRequest(level, value, inTooltip)
	if (level == 1) then
		dewdrop:AddLine(
		    'text', "Skins",
		    'tooltipTitle', "Healbot skins",
		    'tooltipText', "Healbot skins",
		    'hasArrow', true,
		    'value', "HBskinsx"
		)
		dewdrop:AddLine()
		dewdrop:AddLine(
		    'text', "Healbot Options",
		    'tooltipTitle', "Healbot Options",
		    'tooltipText', "Healbot Options",
		    'hasArrow', true,
		    'value', "HBOptions"
		)
		dewdrop:AddLine()
		dewdrop:AddLine(
		    'text', "Reset Healbot",
		    'tooltipTitle', "Reset Healbot",
		    'tooltipText', "Reset Healbot",
		    'func', function()
					-- Reset HB
					_G.HealBot_SetResetFlag("SOFT");
					end
		)
    elseif (level == 2) then
	    if (value == "HBOptions") then
			if (HealBot_Config.DisableHealBot == 1) then disx = true; else disx = false; end
			dewdrop:AddLine(
	  			'text', "Disable Heabot",
	  			'tooltipTitle', "Disable Heabot",
				'tooltipText', "Disable or Enable Heabot",
				'checked', disx,
				'func', function()
					-- diasble HB
					self:DisableHB();
					self:Update()
					end
			)
			if (HealBot_Config.ButtonShown == 1) then mmpbtx = true; else mmpbtx = false; end
			dewdrop:AddLine(
	  			'text', "Minimap button",
	  			'tooltipTitle', "Minimap button",
				'tooltipText', "Show or hide Healbot minimap button",
				'checked', mmpbtx,
				'func', function()
					-- minimap button
					self:HideOldHealBotMinimapButton();
					end
			)
			if (HealBot_Config.ActionLocked == 1) then lockx = true; else lockx = false; end
			dewdrop:AddLine(
	  			'text', "Lock Healbot frame",
	  			'tooltipTitle', "Lock Healbot frame",
				'tooltipText', "Lock or unlock Healbot frame",
				'checked', lockx,
				'func', function()
					-- lock frame
					self:LockHB();
					end
			)
			dewdrop:AddLine()
			if (HealBot_Config.SelfHeals == 1) then yourx = true; else yourx = false; end
			dewdrop:AddLine(
	  			'text', "Show yourself",
	  			'tooltipTitle', "Show yourlsef",
				'tooltipText', "Show yourself on your Healbot frame",
				'checked', yourx,
				'func', function()
					-- yourself
					self:ShowYourselfonHB();
					end
			)
			if (HealBot_Config.GroupHeals == 1) then groupx = true; else groupx = false; end
			dewdrop:AddLine(
	  			'text', "Show group",
	  			'tooltipTitle', "Show group",
				'tooltipText', "Show group on your Healbot frame",
				'checked', groupx,
				'func', function()
					-- group
					self:ShowGrouponHB();
					end
			)
			if (HealBot_Config.TankHeals == 1) then tankx = true; else tankx = false; end
			dewdrop:AddLine(
	  			'text', "Show Tanks",
	  			'tooltipTitle', "Show tanks",
				'tooltipText', "Show tanks on your Healbot frame",
				'checked', tankx,
				'func', function()
					-- tanks
					self:ShowMainTankonHB();
					end
			)
			if (HealBot_Config.SelfPet == 1) then selfpx = true; else selfpx = false; end
			dewdrop:AddLine(
	  			'text', "Show self pet",
	  			'tooltipTitle', "Show self pet",
				'tooltipText', "Show self pet on your Healbot frame",
				'checked', selfpx,
				'func', function()
					-- self pet
					self:ShowSelfpetonHB();
					end
			)
			if (HealBot_Config.EmergencyHeals == 1) then emerx = true; else emerx = false; end
			dewdrop:AddLine(
	  			'text', "Show emergency",
	  			'tooltipTitle', "Show emergency",
				'tooltipText', "Show emergency on your Healbot frame",
				'checked', emerx,
				'func', function()
					-- emergency
					self:ShowEmergencyonHB();
					end
			)
			if (HealBot_Config.PetHeals == 1) then petsx = true; else petsx = false; end
			dewdrop:AddLine(
	  			'text', "Show pets",
	  			'tooltipTitle', "Show pets",
				'tooltipText', "Show pets on your Healbot frame",
				'checked', petsx,
				'func', function()
					-- pets
					self:ShowPetsonHB();
					end
			)
			if (HealBot_Config.ShowMyTargetsList == 1) then	mytx = true; else mytx = false; end
			dewdrop:AddLine(
	  			'text', "Show my targets",
	  			'tooltipTitle', "Show my targets",
				'tooltipText', "Show my targets on your Healbot frame",
				'checked', mytx,
				'func', function()
					-- my targets
					self:ShowMytargetsonHB();
					end
			)
			if (HealBot_Config.SetFocusBar == 1) then focux = true; else focux = false; end
			dewdrop:AddLine(
	  			'text', "Show focus",
	  			'tooltipTitle', "Show focus",
				'tooltipText', "Show focus on your Healbot frame",
				'checked', focux,
				'func', function()
					-- focus
					self:ShowFocusonHB();
					end
			)
			if (HealBot_Config.VehicleHeals == 1) then vehix = true; else vehix = false; end
			dewdrop:AddLine(
	  			'text', "Show vehicle",
	  			'tooltipTitle', "Show vehicle",
				'tooltipText', "Show vehicle on your Healbot frame",
				'checked', vehix,
				'func', function()
					-- vehicle
					self:ShowVehicleonHB();
					end
			)
			if (HealBot_Config.TargetHeals == 1) then tgbx = true; else tgbx = false; end
			dewdrop:AddLine(
	  			'text', "Show target bar",
	  			'tooltipTitle', "Show target bar",
				'tooltipText', "Show target bar on your Healbot frame",
				'checked', tgbx,
				'func', function()
					-- target bar
					self:ShowTargetonHB();
					end
			)
		elseif (value == "HBskinsx") then
			-- Skins list
			-- Special thanks to Strife for the parser
			for x in pairs (Healbot_Config_Skins.Skins) do
				local skinName = Healbot_Config_Skins.Skins[x]
				-- Check if used
				if (Healbot_Config_Skins.Current_Skin == skinName) then skinchx = true; else skinchx = false; end
					dewdrop:AddLine(
					'text', skinName,
					'tooltipTitle', skinName,
					'tooltipText', "Change skin to "..skinName,
					'checked', skinchx,
					'func', function()
						_G.HealBot_Options_Set_Current_Skin(skinName)
						self:Update()
						end
					)
		    end
		end
	end
end

--
-- HBskinFu menu functions
local _G = getfenv(0);
function HBskinFu:OnInitialize()
end

--
-- Reset HB and Open HB menu
function HBskinFu:OnClick()
   if ( IsShiftKeyDown() ) then
      _G.HealBot_SetResetFlag("SOFT");
   else
      _G.HealBot_ToggleOptions();
   end
end

-- Disable HB
function HBskinFu:DisableHB()
   if ( HealBot_Config.DisableHealBot == 1 ) then
      -- hide healbot's
	  _G.HealBot_Options_DisableHealBot:SetChecked(0);
      _G.HealBot_Options_ToggleHealBot(0);
      _G.ShowUIPanel(HealBot_Action)
      --_G.HealBot_Config.DisableHealBot = 0;
   else
      -- show it
      _G.HealBot_Options_DisableHealBot:SetChecked(1);
      _G.HealBot_Options_ToggleHealBot(1);
      _G.HideUIPanel(HealBot_Action);
   end
end
        
-- Minimap
function HBskinFu:HideOldHealBotMinimapButton()
   if ( HealBot_Config.ButtonShown == 1 ) then
      -- hide healbot's regular icon
      _G.HealBot_Options_ShowMinimapButton:SetChecked(false);
      _G.HealBot_Config.ButtonShown = 0;
   else
      -- show it
      _G.HealBot_Options_ShowMinimapButton:SetChecked(true);
      _G.HealBot_Config.ButtonShown = 1;
   end
   _G.HealBot_MMButton_Init();
end

-- Lock frame
function HBskinFu:LockHB()
   if ( HealBot_Config.ActionLocked == 1 ) then
      -- lock HB frame
      _G.HealBot_Options_ActionLocked:SetChecked(false);
      _G.HealBot_Config.ActionLocked = 0;
   else
      -- unlock it
      _G.HealBot_Options_ActionLocked:SetChecked(true);
      _G.HealBot_Config.ActionLocked = 1;
   end
end

-- Yourself
function HBskinFu:ShowYourselfonHB()
   if ( HealBot_Config.SelfHeals == 1 ) then
      -- Show yourself on healbot
      _G.HealBot_Options_SelfHeals:SetChecked(false);
      _G.HealBot_Config.SelfHeals = 0;
      _G.HealBot_SetResetFlag("SOFT");
   else
      -- hide it
      _G.HealBot_Options_SelfHeals:SetChecked(true);
      _G.HealBot_Config.SelfHeals = 1;
      _G.HealBot_SetResetFlag("SOFT");
   end
end

-- group
function HBskinFu:ShowGrouponHB()
   if ( HealBot_Config.GroupHeals == 1 ) then
      -- Show group on healbot
      _G.HealBot_Options_GroupHeals:SetChecked(false);
      _G.HealBot_Config.GroupHeals = 0;
      _G.HealBot_SetResetFlag("SOFT");
   else
      -- hide it
      _G.HealBot_Options_GroupHeals:SetChecked(true);
      _G.HealBot_Config.GroupHeals = 1;
      _G.HealBot_SetResetFlag("SOFT");
   end
end

-- Tanks
function HBskinFu:ShowMainTankonHB()
   if ( HealBot_Config.TankHeals == 1 ) then
      -- Show tanks on healbot
      _G.HealBot_Options_TankHeals:SetChecked(false);
      _G.HealBot_Config.TankHeals = 0;
      _G.HealBot_SetResetFlag("SOFT");
   else
      -- hide it
      _G.HealBot_Options_TankHeals:SetChecked(true);
      _G.HealBot_Config.TankHeals = 1;
      _G.HealBot_SetResetFlag("SOFT");
   end
end

-- Self pet
function HBskinFu:ShowSelfpetonHB()
   if ( HealBot_Config.SelfPet == 1 ) then
      -- Show self pet on healbot
      _G.HealBot_Options_SelfPet:SetChecked(false);
      _G.HealBot_Config.SelfPet = 0;
      _G.HealBot_SetResetFlag("SOFT");
   else
      -- hide it
      _G.HealBot_Options_SelfPet:SetChecked(true);
      _G.HealBot_Config.SelfPet = 1;
      _G.HealBot_SetResetFlag("SOFT");
   end
end

-- Emergency
function HBskinFu:ShowEmergencyonHB()
   if ( HealBot_Config.EmergencyHeals == 1 ) then
      -- Show emergency on healbot
      _G.HealBot_Options_EmergencyHeals:SetChecked(false);
      _G.HealBot_Config.EmergencyHeals = 0;
      _G.HealBot_SetResetFlag("SOFT");
   else
      -- hide it
      _G.HealBot_Options_EmergencyHeals:SetChecked(true);
      _G.HealBot_Config.EmergencyHeals = 1;
      _G.HealBot_SetResetFlag("SOFT");
   end
end

-- Pets
function HBskinFu:ShowPetsonHB()
   if ( HealBot_Config.PetHeals == 1 ) then
      -- Show pets on healbot
      _G.HealBot_Options_PetHeals:SetChecked(false);
      _G.HealBot_Config.PetHeals = 0;
      _G.HealBot_SetResetFlag("SOFT");
   else
      -- hide it
      _G.HealBot_Options_PetHeals:SetChecked(true);
      _G.HealBot_Config.PetHeals = 1;
      _G.HealBot_SetResetFlag("SOFT");
   end
end

-- My targets
function HBskinFu:ShowMytargetsonHB()
   if ( HealBot_Config.ShowMyTargetsList == 1 ) then
      -- Show my targets on healbot
      _G.HealBot_Options_MyTargetsList:SetChecked(false);
      _G.HealBot_Config.ShowMyTargetsList = 0;
      _G.HealBot_SetResetFlag("SOFT");
   else
      -- hide it
      _G.HealBot_Options_MyTargetsList:SetChecked(true);
      _G.HealBot_Config.ShowMyTargetsList = 1;
      _G.HealBot_SetResetFlag("SOFT");
   end
end

-- Focus
function HBskinFu:ShowFocusonHB()
   if ( HealBot_Config.SetFocusBar == 1 ) then
      -- Show focus on healbot
      _G.HealBot_Options_FocusBar:SetChecked(false);
      _G.HealBot_Config.SetFocusBar = 0;
      _G.HealBot_SetResetFlag("SOFT");
   else
      -- hide it
      _G.HealBot_Options_FocusBar:SetChecked(true);
      _G.HealBot_Config.SetFocusBar = 1;
      _G.HealBot_SetResetFlag("SOFT");
   end
end

-- Vehicle
function HBskinFu:ShowVehicleonHB()
   if ( HealBot_Config.VehicleHeals == 1 ) then
      -- Show vehicle on healbot
      _G.HealBot_Options_VehicleHeals:SetChecked(false);
      _G.HealBot_Config.VehicleHeals = 0;
      _G.HealBot_SetResetFlag("SOFT");
   else
      -- hide it
      _G.HealBot_Options_VehicleHeals:SetChecked(true);
      _G.HealBot_Config.VehicleHeals = 1;
      _G.HealBot_SetResetFlag("SOFT");
   end
end

-- Target
function HBskinFu:ShowTargetonHB()
   if ( HealBot_Config.TargetHeals == 1 ) then
      -- Show target on healbot
      _G.HealBot_Options_TargetBar:SetChecked(false);
      _G.HealBot_Config.TargetHeals = 0;
      _G.HealBot_SetResetFlag("SOFT");
   else
      -- hide it
      _G.HealBot_Options_TargetBar:SetChecked(true);
      _G.HealBot_Config.TargetHeals = 1;
      _G.HealBot_SetResetFlag("SOFT");
   end
end

--
-- HBskinFu tooltip
function HBskinFu:OnTooltipUpdate()
	local cat = tablet:AddCategory()
		if (HealBot_Config.DisableHealBot == 0) then
		cat:AddLine(
			"text", "|cffffffffCurrent skin :|r |cff1eff00"..Healbot_Config_Skins.Current_Skin.."|r"
		)
		end
		cat:AddLine()
		cat:AddLine()
		cat:AddLine(
			"text", "|cffffffffLeft click :|r |cff1eff00Open HealBot options.|r"
		)
		cat:AddLine(
			"text", "|cffffffffRight click :|r |cff1eff00Open HBskinFu menu.|r"
		)
        cat:AddLine(
			"text", "|cffffffffShift-Left-Click :|r |cff1eff00Reset HealBot.|r"
		)
end

--
-- HBskinFU Fubar text
function HBskinFu:OnTextUpdate()
	settext = "";
	if (HealBot_Config.DisableHealBot == 0) then
	settext = settext.." |cff1eff00 "..Healbot_Config_Skins.Current_Skin.."|r";
	end
	self:SetText(settext)
end